/******************************************************************************/
class ButtonObject : Game.Static
{
public:
   
    ButtonObject ();
   ~ButtonObject(); 
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      );
   virtual bool update();
   virtual uint drawPrepare();
   
   void Activate();
   void Enable() { m_Enabled = true; }
   
private:
      
   bool m_Enabled, m_CanToggle, m_FirstTick;
   UID m_ToggledOnEventsID, m_ToggledOffEventsID; // ID to the EventGroups. Once the lightswitch is triggered, it will call all the linked events through one of these groups.
   EventGroup* m_EventGroupOn, *m_EventGroupOff;
   
   ENUM_BUTTONSTATE m_ButtonState;
   ENUM_BUTTON_OPERATIONS m_ButtonOperation;
};
/******************************************************************************/
ButtonObject::ButtonObject() : m_Enabled(false), m_ButtonState(UNDEFINED), m_CanToggle(true), m_FirstTick(true), m_EventGroupOn(null), m_EventGroupOff(null)
{
   
}
ButtonObject::~ButtonObject()
{
   
}
/******************************************************************************/
void ButtonObject::create(Object &obj)
{
   super.create(obj);
   
   if(Param *p = obj.findParam("ButtonOperations"))         m_ButtonOperation     = (ENUM_BUTTON_OPERATIONS)p.asEnum();
   if(Param *p = obj.findParam("Enabled"))                  m_Enabled             = p.asBool();
   if(Param *p = obj.findParam("ToggledOff_EventGroupUID")) m_ToggledOffEventsID = p.asID();
   if(Param *p = obj.findParam("ToggledOn_EventGroupUID" )) m_ToggledOnEventsID  = p.asID();
   if(Param *p = obj.findParam("StartState"))               m_ButtonState         = (ENUM_BUTTONSTATE)p.asEnum();
}
/******************************************************************************/
void ButtonObject::AfterCreate()
{
   m_EventGroupOff = GetEventGroupForID(m_ToggledOffEventsID);
   m_EventGroupOn = GetEventGroupForID(m_ToggledOnEventsID);
}
/******************************************************************************/
bool ButtonObject::update()
{
   // On the first frame, call AfterCreate(). This method allows you to initialize all events/objects that need to be called/referenced
   if(m_FirstTick)
   {
      AfterCreate();
      
      m_FirstTick = false;
   }
   
   return super.update();
}
/******************************************************************************/
uint ButtonObject::drawPrepare()
{
   // Highlight this object when the user is hovering over it  
   SetHighlight((interaction.obj==this && interaction.highlight) ? Color(34,85,85) : Color(0,0,0)); 
   UInt modes=super::drawPrepare();
   SetHighlight(Color(0,0,0)); // Apply highlight only to this object, not to anything we will still draw after this
    
   return modes;
}
/******************************************************************************/
void ButtonObject::Activate()
{
   if(m_Enabled && m_CanToggle)
   {
      // Switch state of the button first (if the button was off, it's now on and vice versa)
           if(m_ButtonState == TOGGLED_ON && m_ButtonOperation != REPEAT_TOGGLEON_ONLY) m_ButtonState = TOGGLED_OFF;
      else if(m_ButtonState == TOGGLED_OFF) m_ButtonState = TOGGLED_ON;
      
      // Now fire the proper eventgroup
      if(m_ButtonState == TOGGLED_ON)
      {
         if(m_EventGroupOn)
            m_EventGroupOn.Triggered();
      }
      else if(m_ButtonState == TOGGLED_OFF)
      {
         if(m_EventGroupOff)
            m_EventGroupOff.Triggered();
      }
        
      // Button can no longer toggle 
      if(m_ButtonOperation == CAN_TOGGLE_ONCE)
         m_CanToggle = false;
   }
}
/******************************************************************************/